/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#pragma once

#include <sstream>
#include <string>
#include <unordered_map>
#include <unordered_set>
#include <vector>

namespace msgpack::v2 { struct object; }

static inline std::string to_string(const msgpack::v2::object&) { return "void"; }

static inline const struct BoolAsTrueOrFalseType : std::numpunct<char>
{
	BoolAsTrueOrFalseType()
	    : numpunct(1)
	{}
	std::string do_truename() const override { return "True"; }
	std::string do_falsename() const override { return "False"; }
} BoolAsTrueOrFalse = {};

static constexpr const std::string& to_string(const std::string& str) { return str; }

static constexpr const char* to_string(const char* str) { return str; }

// SFINAE: Enable when there is "ToString" member function.
template<typename T, typename = decltype(((T*)0)->ToString())> static constexpr std::string to_string(const T& obj) { return obj.ToString(); }

/*// SFINAE: Enable when there is "std::to_string" function.
template<typename T, typename = void, typename = decltype(std::to_string(*((T*)0)))>
static constexpr std::string to_string( const T& obj )
{
    return std::to_string(obj);
}*/

template<typename T> std::string to_string(const std::vector<T>& v)
{
	using namespace std;
	stringstream s;
	if (v.size() > 0)
	{
		for (const auto& vv : v)
			// s << ' ' << to_string( vv );
			s << (s.str().length() > 0 ? ", " : "") << to_string(vv);
	}
	return s.str();
}

template<typename T> std::string to_string(const std::unordered_set<T>& v)
{
	using namespace std;
	stringstream s;
	if (v.size() > 0)
	{
		for (const auto& vv : v)
			s << ' ' << to_string(vv);
	}
	return s.str();
}
template<typename K, typename V> std::string to_string(const std::pair<K, V>& obj)
{
	using namespace std;
	stringstream ss;
	ss << "[";
	ss << to_string(obj.first);
	ss << "]{ ";
	ss << to_string(obj.second);
	ss << " }";
	return ss.str();
}
template<typename K, typename V> std::string to_string(const std::unordered_map<K, V>& obj)
{
	using namespace std;
	stringstream s;
	if (obj.size() > 0)
	{
		for (const auto& p : obj)
			s << (s.str().length() > 0 ? ", " : "") << to_string(p);
	}
	return s.str();
}